E_MODEL_SNOWMAN_BOTTOM = smlua_model_util_get_id("snowmans_bottom_geo")
E_MODEL_ROLLING_ROCK2 = smlua_model_util_get_id("rolling_rock2_geo")
E_MODEL_ROLLING_ROCK3 = smlua_model_util_get_id("rolling_rock3_geo")

E_MODEL_YELLOW_YOSHI = smlua_model_util_get_id("yellow_yoshi_geo")
E_MODEL_BLUE_YOSHI = smlua_model_util_get_id("light_blue_yoshi_geo")
E_MODEL_PINK_YOSHI = smlua_model_util_get_id("pink_yoshi_geo")
E_MODEL_RED_YOSHI = smlua_model_util_get_id("red_yoshi_geo")
E_MODEL_PURPLE_YOSHI = smlua_model_util_get_id("purple_yoshi_geo")
E_MODEL_WHITE_YOSHI = smlua_model_util_get_id("white_yoshi_geo")
E_MODEL_BLACK_YOSHI = smlua_model_util_get_id("black_yoshi_geo")

local yoshi = 0
local boulder = 0

-- Rideable Yoshi Behavior.

local SOUND_YOSHI_FLUTTER_SHORT = audio_sample_load("flutter-short.mp3")
local SOUND_YOSHI_HIT = audio_sample_load("yoshi_hit.mp3")

define_custom_obj_fields(
    {
        oYoshiIdleTimer = "f32"
    }
)

function bhv_yoshi_rideable_init(obj)
    cur_obj_init_animation(0)
    obj.oFlags = (OBJ_FLAG_SET_FACE_YAW_TO_MOVE_YAW | OBJ_FLAG_UPDATE_GFX_POS_AND_ANGLE)
    obj.oGravity = -3
    obj.oFriction = 1

    obj.activeFlags = obj.activeFlags | ACTIVE_FLAG_UNK9
    cur_obj_scale(1)

    -- animations
    obj.oAnimations = gObjectAnimations.yoshi_seg5_anims_05024100
    obj.oFaceAnglePitch = 0x00
    obj.oFaceAngleRoll = 0x00
    obj.oAction = 0

    -- hitbox
    obj.oHealth = 1
    obj.oIntangibleTimer = 0

    obj.hitboxRadius = obj.header.gfx.scale.x * 50
    obj.hitboxHeight = obj.header.gfx.scale.y * 40

    -- start synchronizing object
    network_init_object(
        obj,
        true,
        {
            "oYoshiIdleTimer"
        }
    )
end

function bhv_yoshi_rideable_loop(o)
    o.oAnimState = 3
    local player = nearest_mario_state_to_object(o)
    local distanceToPlayer = dist_between_objects(o, player.marioObj)
    local rider = nil

    if o.oAction == 0 then -- Unridden.
        cur_obj_init_animation(0)
        o.oForwardVel = 0
        return bhv_yoshi_unridden(o)
    elseif o.oAction == 2 then
        cur_obj_init_animation_with_accel_and_sound(1, 3)
        cur_obj_play_sound_at_anim_range(0, 15, SOUND_GENERAL_YOSHI_WALK)
        o.oForwardVel = 30
        return bhv_yoshi_unridden(o)
    elseif o.oAction == 1 then -- Ridden.
        local animFrame = o.header.gfx.animInfo.animFrame
        rider = gMarioStates[o.heldByPlayerIndex]
        o.oYoshiIdleTimer = 0

        obj_copy_pos(o, rider.marioObj)
        rider.marioObj.header.gfx.animInfo.animFrame = o.header.gfx.animInfo.animFrame
        o.oMoveAngleYaw = rider.faceAngle.y
        o.oFaceAnglePitch = 0x00
        o.oFaceAngleRoll = 0x00

        if rider.action == ACT_RIDE_YOSHI_IDLE then
            cur_obj_init_animation(0)
        elseif rider.action == ACT_RIDE_YOSHI_WALK then
            cur_obj_init_animation_with_accel_and_sound(1, math.abs(rider.forwardVel) / 14)
            cur_obj_play_sound_at_anim_range(0, 15, SOUND_GENERAL_YOSHI_WALK)
        elseif rider.action == ACT_RIDE_YOSHI_JUMP then
            if rider.vel.y >= -21 then
                cur_obj_init_animation(2)
                if o.header.gfx.animInfo.animFrame >= 4 then
                    o.header.gfx.animInfo.animFrame = 4
                end
            else
                smlua_anim_util_set_animation(o, "YOSHI_FALL")
            end
        elseif rider.action == ACT_RIDE_YOSHI_FALL then
            smlua_anim_util_set_animation(o, "YOSHI_FALL_STATIC")
        elseif rider.action == ACT_RIDE_YOSHI_FLUTTER then
            smlua_anim_util_set_animation(o, "YOSHI_FLUTTER")
            if animFrame == 0 or animFrame == 3 then
                audio_sample_play(SOUND_YOSHI_FLUTTER_SHORT, rider.marioObj.header.gfx.cameraToObject, 1)
            end
        else
            mario_stop_riding_object(rider)
        end

        if (o.oInteractStatus & INT_STATUS_STOP_RIDING) ~= 0 then
            o.heldByPlayerIndex = 0
            if rider.hurtCounter ~= 0 then
                audio_sample_play(SOUND_YOSHI_HIT, rider.marioObj.header.gfx.cameraToObject, 1)
                o.oAction = 2
            else
                o.oAction = 0
            end
            o.oInteractStatus = 0
        end
    end
end

function bhv_yoshi_unridden(o)
    local player = nearest_mario_state_to_object(o)
    local distanceToPlayer = dist_between_objects(o, player.marioObj)
    local rider = nil

    o.oYoshiIdleTimer = o.oYoshiIdleTimer + 1
    cur_obj_move_standard(-78)
    cur_obj_update_floor_and_walls()
    cur_obj_if_hit_wall_bounce_away()
    if distanceToPlayer < 100 then
        lua_push_mario_out_of_object(player, o, 2)
    end

    if o.oYoshiIdleTimer >= 800 then
        spawn_mist_particles_with_sound(SOUND_OBJ_DYING_ENEMY1)
        obj_mark_for_deletion(o)
    end

    o.oInteractStatus = 0

    local yoshiRidingActions = {
        [ACT_RIDE_YOSHI_IDLE] = true,
        [ACT_RIDE_YOSHI_WALK] = true,
        [ACT_RIDE_YOSHI_JUMP] = true,
        [ACT_RIDE_YOSHI_FALL] = true,
        [ACT_RIDE_YOSHI_FLUTTER] = true,
        [ACT_FALL_AFTER_STAR_GRAB] = true
    }

    local yoshiGrabbingActions = {
        [ACT_PUNCHING] = true,
        [ACT_MOVE_PUNCHING] = true,
        [ACT_DIVE] = true,
        [ACT_DIVE_SLIDE] = true
    }

    if not yoshiRidingActions[player.action] then
        if
            (((player.action & ACT_FLAG_AIR) ~= 0 and (player.action & ACT_FLAG_SWIMMING_OR_FLYING) == 0 and
                player.vel.y <= 0) and
                distanceToPlayer < 85) or
                (((yoshiGrabbingActions[player.action]) and player.actionArg == 2) and distanceToPlayer < 100)
         then
            player.pos.x = o.oPosX
            player.pos.z = o.oPosZ
            player.faceAngle.y = o.oMoveAngleYaw
            cur_obj_play_sound_2(SOUND_GENERAL_YOSHI_TALK)
            player.interactObj = o
            player.usedObj = o
            player.riddenObj = o
            o.oAction = 1
            o.heldByPlayerIndex = player.playerIndex

            return set_mario_action(player, ACT_RIDE_YOSHI_IDLE, 0)
        end
    end
end

-- Nest Yoshi Behavior.

define_custom_obj_fields(
    {
        oYoshiNestRespawnDelay = "f32"
    }
)

function bhv_yoshi_nest_init(obj)
    obj.oFlags = (OBJ_FLAG_SET_FACE_YAW_TO_MOVE_YAW | OBJ_FLAG_UPDATE_GFX_POS_AND_ANGLE)
    obj.oGravity = -3
    obj.oFriction = 1

    obj.activeFlags = obj.activeFlags | ACTIVE_FLAG_UNK9
    cur_obj_scale(1)

    -- animations
    obj.oFaceAnglePitch = 0x00
    obj.oFaceAngleRoll = 0x00
    obj.oYoshiNestRespawnDelay = 10

    -- hitbox
    obj.oHealth = 1
    obj.oIntangibleTimer = 0

    obj.hitboxRadius = obj.header.gfx.scale.x * 50
    obj.hitboxHeight = obj.header.gfx.scale.y * 50

    -- start synchronizing object
    -- network_init_object(obj, nil, {"oYoshiNestRespawnDelay"})
end

function bhv_yoshi_nest_loop(o)
    local player = nearest_mario_state_to_object(o)
    local egg = obj_get_nearest_object_with_behavior_id(o, id_bhvYoshiSpawnEgg)

    if (egg == nil or dist_between_objects(o, egg) > 40) then
        o.oYoshiNestRespawnDelay = o.oYoshiNestRespawnDelay - 1
        if o.oYoshiNestRespawnDelay <= 0 then
            if player.playerIndex == 0 then
                spawn_sync_object(
                    id_bhvYoshiSpawnEgg,
                    E_MODEL_YOSHI_EGG,
                    o.oPosX,
                    o.oPosY,
                    o.oPosZ,
                    function(obj)
                        spawn_mist_particles()
                    end
                )
            end
            o.oYoshiNestRespawnDelay = 600
        end
    end
end

-- Handles Yoshi egg.

define_custom_obj_fields(
    {
        oYoshiEggScale = "f32",
        oYoshiEggRespawnTimer = "f32"
    }
)

local SOUND_YOSHI_EGG_HATCH = audio_sample_load("egg_hatch.mp3")

function bhv_yoshi_spawn_egg_init(obj)
    obj.oFlags = (OBJ_FLAG_COMPUTE_ANGLE_TO_MARIO | OBJ_FLAG_COMPUTE_DIST_TO_MARIO | OBJ_FLAG_UPDATE_GFX_POS_AND_ANGLE)
    obj.oGravity = -3
    obj.oFriction = 1

    obj.oHomeX = obj.oPosX
    obj.oHomeY = obj.oPosY
    obj.oHomeZ = obj.oPosZ

    obj.activeFlags = obj.activeFlags | ACTIVE_FLAG_UNK9

    -- animations
    obj.oFaceAnglePitch = 0x00
    obj.oFaceAngleRoll = 0x00

    -- hitbox
    obj.oInteractType = INTERACT_BREAKABLE
    obj.oHealth = 1
    obj.oIntangibleTimer = 0
    obj.oYoshiEggScale = 1.8
    obj.hitboxRadius = obj.oYoshiEggScale * 50
    obj.hitboxHeight = obj.oYoshiEggScale * 50

    obj_set_billboard(obj)

    -- start synchronizing object
    network_init_object(
        obj,
        true,
        {
            "oYoshiEggScale"
        }
    )
end

function bhv_yoshi_spawn_egg_loop(o)
    local player = nearest_mario_state_to_object(o)
    local distanceToPlayer = dist_between_objects(o, player.marioObj)
    local e = gStateExtras[player.playerIndex]
    cur_obj_scale(o.oYoshiEggScale)

    if o.oAnimState > 7 then
        o.oAnimState = 0
    end

    o.oAnimState = o.oAnimState + 1
    if (o.oInteractStatus & INT_STATUS_INTERACTED) ~= 0 then
        spawn_yoshi_from_egg(o)
        o.oInteractStatus = 0
    end

    cur_obj_move_standard(-78)
    cur_obj_update_floor_and_walls()
    cur_obj_if_hit_wall_bounce_away()
    o.oForwardVel = 0
    if distanceToPlayer < 100 * o.oYoshiEggScale then
        if (player.action & ACT_FLAG_AIR) == 0 then
            lua_push_mario_out_of_object(player, o, 2)
        end
    end
    return 0
end

function spawn_yoshi_from_egg(o)
    local player = nearest_mario_state_to_object(o)
    if player.playerIndex == 0 then
      yoshi = math.random(1,8)
        if yoshi == 1 then
        spawn_sync_object(
            id_bhvYoshiRideable,
            E_MODEL_YOSHI,
            o.oPosX,
            o.oPosY,
            o.oPosZ,
            function(obj)
                spawn_mist_particles()
                obj.oVelY = 0
            end
        )
        end
        if yoshi == 2 then
        spawn_sync_object(
            id_bhvYoshiRideable,
            E_MODEL_YELLOW_YOSHI,
            o.oPosX,
            o.oPosY,
            o.oPosZ,
            function(obj)
                spawn_mist_particles()
                obj.oVelY = 0
            end
        )
        end
        if yoshi == 3 then
        spawn_sync_object(
            id_bhvYoshiRideable,
            E_MODEL_BLUE_YOSHI,
            o.oPosX,
            o.oPosY,
            o.oPosZ,
            function(obj)
                spawn_mist_particles()
                obj.oVelY = 0
            end
        )
        end
        if yoshi == 4 then
        spawn_sync_object(
            id_bhvYoshiRideable,
            E_MODEL_PINK_YOSHI,
            o.oPosX,
            o.oPosY,
            o.oPosZ,
            function(obj)
                spawn_mist_particles()
                obj.oVelY = 0
            end
        )
        end
        if yoshi == 5 then
        spawn_sync_object(
            id_bhvYoshiRideable,
            E_MODEL_RED_YOSHI,
            o.oPosX,
            o.oPosY,
            o.oPosZ,
            function(obj)
                spawn_mist_particles()
                obj.oVelY = 0
            end
        )
        end
        if yoshi == 6 then
        spawn_sync_object(
            id_bhvYoshiRideable,
            E_MODEL_PURPLE_YOSHI,
            o.oPosX,
            o.oPosY,
            o.oPosZ,
            function(obj)
                spawn_mist_particles()
                obj.oVelY = 0
            end
        )
        end
        if yoshi == 7 then
        spawn_sync_object(
            id_bhvYoshiRideable,
            E_MODEL_WHITE_YOSHI,
            o.oPosX,
            o.oPosY,
            o.oPosZ,
            function(obj)
                spawn_mist_particles()
                obj.oVelY = 0
            end
        )
        end
        if yoshi == 8 then
        spawn_sync_object(
            id_bhvYoshiRideable,
            E_MODEL_BLACK_YOSHI,
            o.oPosX,
            o.oPosY,
            o.oPosZ,
            function(obj)
                spawn_mist_particles()
                obj.oVelY = 0
            end
        )
        end
    end
    audio_sample_play(SOUND_YOSHI_EGG_HATCH, o.header.gfx.cameraToObject, 4)
    obj_mark_for_deletion(o)
end

-- Launchpad ported from sm64js; texture by 0x2480

COL_LAUNCHPAD = smlua_collision_util_get("launchpad_collision")

--- @param o Object
function bhv_launchpad_init(o)
    o.oFlags = OBJ_FLAG_UPDATE_GFX_POS_AND_ANGLE
    o.oCollisionDistance = 500
    o.collisionData = COL_LAUNCHPAD
    obj_scale(o, 0.85)
end

--- @param o Object
function bhv_launchpad_loop(o)
    local m = nearest_mario_state_to_object(o)
    if m.marioObj.platform == o then
        play_mario_jump_sound(m)
        if o.oBehParams2ndByte == 0 then
            set_mario_action(m, ACT_TWIRLING, 0)
            m.vel.y = 20
        end
        if o.oBehParams2ndByte == 1 then
            set_mario_action(m, ACT_TWIRLING, 0)
            m.vel.y = 40
        end
        if o.oBehParams2ndByte == 2 then
            set_mario_action(m, ACT_TWIRLING, 0)
            m.vel.y = 60
        end
        if o.oBehParams2ndByte == 3 then
            set_mario_action(m, ACT_TWIRLING, 0)
            m.vel.y = 80
        end
        if o.oBehParams2ndByte == 4 then
            set_mario_action(m, ACT_TWIRLING, 0)
            m.vel.y = 100
        end
        if o.oBehParams2ndByte == 5 then
            set_mario_action(m, ACT_TWIRLING, 0)
            m.vel.y = 120
        end
        if o.oBehParams2ndByte == 6 then
            set_mario_action(m, ACT_TWIRLING, 0)
            m.vel.y = 140
        end
        if o.oBehParams2ndByte == 7 then
            set_mario_action(m, ACT_TWIRLING, 0)
            m.vel.y = 160
        end
        if o.oBehParams2ndByte == 8 then
            set_mario_action(m, ACT_TWIRLING, 0)
            m.vel.y = 180
        end
        if o.oBehParams2ndByte == 9 then -- humor
            spawn_non_sync_object(
                id_bhvWingCap,
                E_MODEL_MARIOS_WING_CAP,
                m.pos.x + m.vel.x, m.pos.y + m.vel.y, m.pos.z + m.vel.z,
                nil
            )
            set_mario_action(m, ACT_FLYING_TRIPLE_JUMP, 0)
            m.forwardVel = m.forwardVel + 45
            m.vel.y = 200
        end
    end
    load_object_collision_model()
end

-- Generator Behavior.

define_custom_obj_fields(
    {
        oGeneratorRespawnDelay = "f32"
    }
)

function bhv_generator_init(obj)
    obj.oFlags = (OBJ_FLAG_SET_FACE_YAW_TO_MOVE_YAW | OBJ_FLAG_UPDATE_GFX_POS_AND_ANGLE)
    obj.oGravity = -3
    obj.oFriction = 1

    obj.activeFlags = obj.activeFlags | ACTIVE_FLAG_UNK9
    cur_obj_scale(1)

    -- animations
    obj.oFaceAnglePitch = 0x00
    obj.oFaceAngleRoll = 0x00
    obj.oGeneratorRespawnDelay = 30

    -- hitbox
    obj.oHealth = 1
    obj.oIntangibleTimer = 0

    obj.hitboxRadius = obj.header.gfx.scale.x * 50
    obj.hitboxHeight = obj.header.gfx.scale.y * 50

    -- start synchronizing object
    -- network_init_object(obj, nil, {"oGeneratorRespawnDelay"})
end

function bhv_generator_loop(o)
    local player = nearest_mario_state_to_object(o)
    local boulder = obj_get_nearest_object_with_behavior_id(o, id_bhvBigBoulder)

    if (boulder == nil or dist_between_objects(o, boulder) > 40) then
        o.oGeneratorRespawnDelay = o.oGeneratorRespawnDelay - 1
        if o.oGeneratorRespawnDelay <= 0 then
            if player.playerIndex == 0 and o.oBehParams2ndByte == 0 then
                spawn_sync_object(
                    id_bhvBigBoulder,
                    E_MODEL_HMC_ROLLING_ROCK,
                    o.oPosX,
                    o.oPosY,
                    o.oPosZ,
                    function(obj)
                        spawn_mist_particles()
                        obj.oMoveAngleYaw = o.oFaceAngleYaw
                    end
                )
            end
            if player.playerIndex == 0 and o.oBehParams2ndByte == 1 then
                spawn_sync_object(
                    id_bhvBigBoulder,
                    E_MODEL_SNOWMAN_BOTTOM,
                    o.oPosX,
                    o.oPosY,
                    o.oPosZ,
                    function(obj)
                        spawn_mist_particles()
                        obj.oMoveAngleYaw = o.oFaceAngleYaw
                    end
                )
            end
            if player.playerIndex == 0 and o.oBehParams2ndByte == 2 then
                spawn_sync_object(
                    id_bhvBigBoulder,
                    E_MODEL_ROLLING_ROCK2,
                    o.oPosX,
                    o.oPosY,
                    o.oPosZ,
                    function(obj)
                        spawn_mist_particles()
                        obj.oMoveAngleYaw = o.oFaceAngleYaw
                    end
                )
            end
            if player.playerIndex == 0 and o.oBehParams2ndByte == 3 then
                spawn_sync_object(
                    id_bhvBigBoulder,
                    E_MODEL_ROLLING_ROCK3,
                    o.oPosX,
                    o.oPosY,
                    o.oPosZ,
                    function(obj)
                        spawn_mist_particles()
                        obj.oMoveAngleYaw = o.oFaceAngleYaw
                    end
                )
            end
            if player.playerIndex == 0 and o.oBehParams2ndByte == 4 then
               boulder = math.random(1,4)
               if boulder == 1 then
                spawn_sync_object(
                    id_bhvBigBoulder,
                    E_MODEL_HMC_ROLLING_ROCK,
                    o.oPosX,
                    o.oPosY,
                    o.oPosZ,
                    function(obj)
                        spawn_mist_particles()
                        obj.oMoveAngleYaw = o.oFaceAngleYaw
                    end
                )
               end
               if boulder == 2 then
                spawn_sync_object(
                    id_bhvBigBoulder,
                    E_MODEL_SNOWMAN_BOTTOM,
                    o.oPosX,
                    o.oPosY,
                    o.oPosZ,
                    function(obj)
                        spawn_mist_particles()
                        obj.oMoveAngleYaw = o.oFaceAngleYaw
                    end
                )
               end
               if boulder == 3 then
                spawn_sync_object(
                    id_bhvBigBoulder,
                    E_MODEL_ROLLING_ROCK2,
                    o.oPosX,
                    o.oPosY,
                    o.oPosZ,
                    function(obj)
                        spawn_mist_particles()
                        obj.oMoveAngleYaw = o.oFaceAngleYaw
                    end
                )
               end
               if boulder == 4 then
                spawn_sync_object(
                    id_bhvBigBoulder,
                    E_MODEL_ROLLING_ROCK3,
                    o.oPosX,
                    o.oPosY,
                    o.oPosZ,
                    function(obj)
                        spawn_mist_particles()
                        obj.oMoveAngleYaw = o.oFaceAngleYaw
                    end
                )
               end
            end
            if o.oBehParams == 0 then
            	o.oGeneratorRespawnDelay = 60
            end
            if o.oBehParams == 1 then
            	o.oGeneratorRespawnDelay = 110
            end
            if o.oBehParams == 2 then
            	o.oGeneratorRespawnDelay = 160
            end
            if o.oBehParams == 3 then
            	o.oGeneratorRespawnDelay = 210
            end
        end
    end
end

-- Fake Star Behavior.

define_custom_obj_fields(
    {
        oSpeed = "f32"
    }
)

function bhv_fake_star_init(obj)
    obj.oFlags = (OBJ_FLAG_UPDATE_GFX_POS_AND_ANGLE | OBJ_FLAG_COMPUTE_ANGLE_TO_MARIO | OBJ_FLAG_COMPUTE_DIST_TO_MARIO | OBJ_FLAG_SET_FACE_YAW_TO_MOVE_YAW)
    obj.oGravity = 0
    obj.oFriction = 1

    obj.activeFlags = obj.activeFlags | ACTIVE_FLAG_UNK9
    cur_obj_scale(1)

    -- animations
    obj.oFaceAnglePitch = 0x00
    obj.oFaceAngleRoll = 0x00
    obj.oSpeed = 2048

    -- hitbox
    obj.oInteractionSubtype = INT_SUBTYPE_BIG_KNOCKBACK
    obj.oInteractType = INTERACT_DAMAGE
    obj.oHealth = 1
    obj.oIntangibleTimer = 0

    obj.hitboxHeight = 113
    obj.hitboxRadius = 65
    obj.hitboxDownOffset = 0
    obj.oBuoyancy = 1.3

end

function bhv_fake_star_loop(o)
    if o.oBehParams2ndByte == 0 then
      if (o.oSpeed) then
           o.oMoveAngleYaw = o.oFaceAngleYaw + o.oSpeed
      end
    end
    if o.oBehParams2ndByte == 1 then
      if (o.oSpeed) then
           o.oMoveAngleYaw = o.oFaceAngleYaw - o.oSpeed
      end
    end

end

id_bhvYoshiRideable = hook_behavior(nil, OBJ_LIST_PUSHABLE, true, bhv_yoshi_rideable_init, bhv_yoshi_rideable_loop)
id_bhvYoshiNest = hook_behavior(nil, OBJ_LIST_DEFAULT, true, bhv_yoshi_nest_init, bhv_yoshi_nest_loop)
id_bhvYoshiSpawnEgg = hook_behavior(nil, OBJ_LIST_PUSHABLE, true, bhv_yoshi_spawn_egg_init, bhv_yoshi_spawn_egg_loop)
id_bhvLaunchpad = hook_behavior(nil, OBJ_LIST_SURFACE, true, bhv_launchpad_init, bhv_launchpad_loop)
id_bhvGenerator = hook_behavior(nil, OBJ_LIST_DEFAULT, true, bhv_generator_init, bhv_generator_loop)
id_bhvFakeStar = hook_behavior(nil, OBJ_LIST_DEFAULT, true, bhv_fake_star_init, bhv_fake_star_loop)